/*   OpenMP version of fadvance */
/*   included by fadvance.c     */

extern int nrn_inthread_; /* defined by multicore.c */

void* nrn_fixed_step_group_omp(void);
void* nrn_fixed_step_omp(void);


void nrn_multithread_job_omp(void*(*job)(NrnThread*)) {
  int i;

  nrn_inthread_ = 1;
#pragma omp parallel for num_threads(8)
  for (i=0; i < nrn_nthread; i++) {
    (*job)(nrn_threads + i);
  }
  nrn_inthread_ = 0;
}


void* nrn_fixed_step_group_omp(void) {
  int i;
  NrnThread *nth;

  nth = &(nrn_threads[0]);
  nth->_stop_stepping = 0;

  for (i = step_group_begin; i < step_group_n; ++i) {

    nrn_fixed_step_omp();

    if (nth->_stop_stepping) {
      //if (nth->id == 0) { step_group_end = i + 1; }
      step_group_end = i + 1;
      nth->_stop_stepping = 0;
      return (void*)0;
    }
  }
  //if (nth->id == 0) { step_group_end = step_group_n; }
  step_group_end = step_group_n;
  return (void*)0;
}


void* nrn_fixed_step_omp(void) {
  double wt;
  int i;
  NrnThread *nth;

  
  nrn_inthread_ = 1;
  //#pragma omp parallel
  {
    // deliver 1
#ifdef KPLUS_FAPP
    fapp_start("deliver1", 1, 1);
#endif
    for(i=0; i< nrn_nthread; i++){
      nth = &(nrn_threads[i]);
      deliver_net_events(nth);
    }
#ifdef KPLUS_FAPP
    fapp_stop("deliver1", 1, 1);
#endif

    // solve
#ifdef KPLUS_FAPP
    fapp_start("solve", 2, 1);
#endif
    wt = nrnmpi_wtime();
#pragma omp parallel for
    for(i=0; i < nrn_nthread; i++){
      nth = &(nrn_threads[i]);
      nrn_random_play(nth);
#if ELIMINATE_T_ROUNDOFF
      nth->nrn_ndt_ += .5;
      nth->_t = nrn_tbase_ + nth->nrn_ndt_ * nrn_dt_;
#else
      nth->_t += .5 * nth->_dt;
#endif
      fixed_play_continuous(nth);
      setup_tree_matrix(nth);
      nrn_solve(nth);
      second_order_cur(nth);
      update(nth);
      CTADD
    }
#ifdef KPLUS_FAPP
    fapp_stop("solve", 2, 1);
#endif

    if (!nrnthread_v_transfer_) {
      // last part start
      // nonvint
#ifdef KPLUS_FAPP
      fapp_start("nonvint", 3, 1);
#endif
      CTBEGIN

#pragma omp parallel for
      for(i=0; i < nrn_nthread; i++){
	nth = &(nrn_threads[i]);

#if ELIMINATE_T_ROUNDOFF
	nth->nrn_ndt_ += .5;
	nth->_t = nrn_tbase_ + nth->nrn_ndt_ * nrn_dt_;
#else
	nth->_t += .5 * nth->_dt;
#endif
	fixed_play_continuous(nth);
	    
	nonvint(nth);
	nrn_ba(nth, AFTER_SOLVE);
	fixed_record_continuous(nth);
	CTADD
      }
#ifdef KPLUS_FAPP
      fapp_stop("nonvint", 3, 1);
#endif

      // deliver 2
#ifdef KPLUS_FAPP
      fapp_start("deliver2", 4, 1);
#endif
      for(i=0; i < nrn_nthread; i++){
	nth = &(nrn_threads[i]);
	nrn_deliver_events(nth) ; /* up to but not past texit */
      }
#ifdef KPLUS_FAPP
      fapp_stop("deliver2", 4, 1);
#endif
    }
  }
  nrn_inthread_ = 0;
  return (void*)0;
}
